/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.Messages;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.util.WorkbenchBrowserUtil;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InstallDebuggerPromptStatusHandler
implements IStatusHandler {
    private static final String URL_INSTALL_PDM = "http://go.appcelerator.com/Install+PDM";
    private static final String URL_DOCS_INSTALL_DEBUGGER = "http://go.appcelerator.com/Installing+the+JavaScript+debugger";
    private static final String URL_DOCS_INSTALL_IE_DEBUGGER = "http://go.appcelerator.com/Installing+the+Internet+Explorer+debugger";

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Shell shell = UIUtils.getActiveShell();
        String title = Messages.InstallDebuggerPromptStatusHandler_InstallDebuggerExtension;
        if ("install".equals(source)) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)Messages.InstallDebuggerPromptStatusHandler_WaitbrowserLaunches_AcceptExtensionInstallation_Quit);
            return null;
        }
        if ("postinstall".equals(source)) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)Messages.InstallDebuggerPromptStatusHandler_WaitbrowserLaunches_Quit);
            return null;
        }
        if ("nopdm".equals(source)) {
            MessageDialog md = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, Messages.InstallDebuggerPromptStatusHandler_PDMNotInstalled, 4, new String[]{StringUtil.ellipsify((String)Messages.InstallDebuggerPromptStatusHandler_Download), CoreStrings.CONTINUE, CoreStrings.CANCEL, CoreStrings.HELP}, 0);
            switch (md.open()) {
                case 0: {
                    WorkbenchBrowserUtil.launchExternalBrowser((String)URL_INSTALL_PDM, (String)"org.eclipse.ui.browser.ie");
                    return Boolean.TRUE;
                }
                case 1: {
                    return Boolean.TRUE;
                }
                case 3: {
                    WorkbenchBrowserUtil.launchExternalBrowser((String)URL_DOCS_INSTALL_IE_DEBUGGER);
                    return Boolean.TRUE;
                }
            }
            return null;
        }
        if (source instanceof String && ((String)source).startsWith("quit_")) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)MessageFormat.format(Messages.InstallDebuggerPromptStatusHandler_BrowserIsRunning, ((String)source).substring(5)));
            return null;
        }
        if (source instanceof String && ((String)source).startsWith("installed_")) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)MessageFormat.format(Messages.InstallDebuggerPromptStatusHandler_ExtensionInstalled, ((String)source).substring(10)));
            return null;
        }
        if (source instanceof String && ((String)source).startsWith("warning_")) {
            MessageDialog.openWarning((Shell)shell, (String)title, (String)((String)source).substring(8));
            return null;
        }
        if (source instanceof String && ((String)source).startsWith("failed_")) {
            MessageDialog md = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, MessageFormat.format(Messages.InstallDebuggerPromptStatusHandler_ExtensionInstallFailed, ((String)source).substring(7)), 1, new String[]{IDialogConstants.OK_LABEL, CoreStrings.HELP}, 0);
            while (true) {
                switch (md.open()) {
                    case 0: {
                        return null;
                    }
                }
                String urlString = ((String)source).indexOf("Internet Explorer") != -1 ? URL_DOCS_INSTALL_IE_DEBUGGER : URL_DOCS_INSTALL_DEBUGGER;
                WorkbenchBrowserUtil.launchExternalBrowser((String)urlString);
            }
        }
        IPreferenceStore store = JSDebugUIPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("com.aptana.js.debug.ui.install_debugger");
        if (pref != null && pref.equals("always")) {
            return Boolean.TRUE;
        }
        String message = MessageFormat.format(Messages.InstallDebuggerPromptStatusHandler_ExtensionNotInstalled, (String)source);
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, title, null, message, 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, CoreStrings.HELP}, 2, null, false);
        dialog.setPrefKey("com.aptana.js.debug.ui.install_debugger");
        dialog.setPrefStore(store);
        while (true) {
            switch (dialog.open()) {
                case 2: {
                    return Boolean.TRUE;
                }
                case 3: {
                    return Boolean.FALSE;
                }
            }
            String urlString = ((String)source).indexOf("Internet Explorer") != -1 ? URL_DOCS_INSTALL_IE_DEBUGGER : URL_DOCS_INSTALL_DEBUGGER;
            WorkbenchBrowserUtil.launchExternalBrowser((String)urlString);
        }
    }
}

